<?php
/************************************************************************
 * This file is part of EspoCRM.
 *
 * EspoCRM - Open Source CRM application.
 * Copyright (C) 2014-2021 Yurii Kuznietsov, Taras Machyshyn, Oleksii Avramenko
 * Website: https://www.espocrm.com
 *
 * EspoCRM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EspoCRM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with EspoCRM. If not, see http://www.gnu.org/licenses/.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "EspoCRM" word.
 ************************************************************************/

namespace Espo\Core\Portal\Utils;

class Url
{
    public static function detectPortalId() : ?string
    {
        $portalId = $_SERVER['ESPO_PORTAL_ID'] ?? null;

        if ($portalId) {
            return $portalId;
        }

        $url = $_SERVER['REQUEST_URI'];

        $portalId = explode('/', $url)[count(explode('/', $_SERVER['SCRIPT_NAME'])) - 1] ?? null;

        if (strpos($url, '=') !== false) {
            $portalId = null;
        }

        if ($portalId) {
            return $portalId;
        }

        $url = $_SERVER['REDIRECT_URL'] ?? null;

        if (!$url) {
            return null;
        }

        $portalId = explode('/', $url)[count(explode('/', $_SERVER['SCRIPT_NAME'])) - 1] ?? null;

        return $portalId;
    }

    protected static function detectIsCustomUrl() : bool
    {
        return (bool) ($_SERVER['ESPO_PORTAL_IS_CUSTOM_URL'] ?? false);
    }

    public static function detectIsInPortalDir() : bool
    {
        $isCustomUrl = self::detectIsCustomUrl();

        if ($isCustomUrl) {
            return false;
        }

        $url = $_SERVER['REQUEST_URI'];

        $a = explode('?', $url);

        $url = rtrim($a[0], '/');

        return strpos($url, '/portal') !== false ;
    }

    public static function detectIsInPortalWithId() : bool
    {
        if (!self::detectIsInPortalDir()) {
            return false;
        }

        $url = $_SERVER['REQUEST_URI'];

        $a = explode('?', $url);

        $url = rtrim($a[0], '/');

        $folders = explode('/', $url);

        if (count($folders) > 1 && $folders[count($folders) - 2] === 'portal') {
            return true;
        }

        return false;
    }
}
