<?php

declare(strict_types=1);

namespace PackageVersions;

use Composer\InstalledVersions;
use OutOfBoundsException;

class_exists(InstalledVersions::class);

/**
 * This class is generated by composer/package-versions-deprecated, specifically by
 * @see \PackageVersions\Installer
 *
 * This file is overwritten at every run of `composer install` or `composer update`.
 *
 * @deprecated in favor of the Composer\InstalledVersions class provided by Composer 2. Require composer-runtime-api:^2 to ensure it is present.
 */
final class Versions
{
    /**
     * @deprecated please use {@see self::rootPackageName()} instead.
     *             This constant will be removed in version 2.0.0.
     */
    const ROOT_PACKAGE_NAME = 'espocrm/espocrm';

    /**
     * Array of all available composer packages.
     * Dont read this array from your calling code, but use the \PackageVersions\Versions::getVersion() method instead.
     *
     * @var array<string, string>
     * @internal
     */
    const VERSIONS          = array (
  'cboden/ratchet' => 'v0.4.1@0d31f3a8ad4795fd48397712709e55cd07f51360',
  'composer/package-versions-deprecated' => '1.11.99.1@7413f0b55a051e89485c5cb9f765fe24bb02a7b6',
  'composer/semver' => '3.0.0@3426bd5efa8a12d230824536c42a8a4ad30b7940',
  'container-interop/container-interop' => '1.2.0@79cbf1341c22ec75643d841642dd5d6acd83bdb8',
  'doctrine/cache' => '1.10.2@13e3381b25847283a91948d04640543941309727',
  'doctrine/dbal' => '3.0.0@ee6d1260d5cc20ec506455a585945d7bdb98662c',
  'doctrine/event-manager' => '1.1.1@41370af6a30faa9dc0368c4a6814d596e81aba7f',
  'dragonmantank/cron-expression' => '3.0.1@fa4e95ff5a7f1d62c3fbc05c32729b7f3ca14b52',
  'evenement/evenement' => 'v3.0.1@531bfb9d15f8aa57454f5f0285b18bec903b8fb7',
  'ezyang/htmlpurifier' => 'v4.13.0@08e27c97e4c6ed02f37c5b2b20488046c8d90d75',
  'fig/http-message-util' => '1.1.4@3242caa9da7221a304b8f84eb9eaddae0a7cf422',
  'guzzlehttp/psr7' => '1.6.1@239400de7a173fe9901b9ac7c06497751f00727a',
  'laminas/laminas-ldap' => '2.10.3@649fae8982149b93071c4a7d56f2c4efeed51aa8',
  'laminas/laminas-loader' => '2.6.1@5d01c2c237ae9e68bec262f339947e2ea18979bc',
  'laminas/laminas-mail' => '2.10.0@019fb670c1dff6be7fc91d3b88942bd0a5f68792',
  'laminas/laminas-mime' => '2.7.1@7fb16c0268a1cad3ea420ee0077daba3b3cf7edd',
  'laminas/laminas-servicemanager' => '3.5.1@0d4c8628a71fae9f7bd0b1b74b76382e5e9a04b1',
  'laminas/laminas-stdlib' => '3.2.1@2b18347625a2f06a1a485acfbc870f699dbe51c6',
  'laminas/laminas-validator' => '2.13.4@93593684e70b8ed1e870cacd34ca32b0c0ace185',
  'laminas/laminas-zendframework-bridge' => '1.1.1@6ede70583e101030bcace4dcddd648f760ddf642',
  'maennchen/zipstream-php' => '2.1.0@c4c5803cc1f93df3d2448478ef79394a5981cc58',
  'markbaker/complex' => '2.0.0@9999f1432fae467bc93c53f357105b4c31bb994c',
  'markbaker/matrix' => '2.1.2@361c0f545c3172ee26c3d596a0aa03f0cef65e6a',
  'michelf/php-markdown' => '1.8.0@01ab082b355bf188d907b9929cd99b2923053495',
  'monolog/monolog' => '2.1.1@f9eee5cec93dfb313a38b6b288741e84e53f02d5',
  'myclabs/php-enum' => '1.7.7@d178027d1e679832db9f38248fcc7200647dc2b7',
  'nesbot/carbon' => '2.26.0@e01ecc0b71168febb52ae1fdc1cfcc95428e604e',
  'nikic/fast-route' => 'v1.3.0@181d480e08d9476e61381e04a71b34dc0432e812',
  'opis/closure' => '3.1.1@d3209e46ad6c69a969b705df0738fd0dbe26ef9e',
  'phpoffice/phpspreadsheet' => '1.16.0@76d4323b85129d0c368149c831a07a3e258b2b50',
  'psr/container' => '1.0.0@b7ce3b176482dbbc1245ebf52b181af44c2cf55f',
  'psr/http-client' => '1.0.1@2dfb5f6c5eff0e91e20e913f8c5452ed95b86621',
  'psr/http-factory' => '1.0.1@12ac7fcd07e5b077433f5f2bee95b3a771bf61be',
  'psr/http-message' => '1.0.1@f6561bf28d520154e4b0ec72be95418abe6d9363',
  'psr/http-server-handler' => '1.0.1@aff2f80e33b7f026ec96bb42f63242dc50ffcae7',
  'psr/http-server-middleware' => '1.0.1@2296f45510945530b9dceb8bcedb5cb84d40c5f5',
  'psr/log' => '1.1.3@0f73288fd15629204f9d42b7055f72dacbe811fc',
  'psr/simple-cache' => '1.0.1@408d5eafb83c57f6365a3ca330ff23aa4a5fa39b',
  'ralouphie/getallheaders' => '3.0.3@120b605dfeb996808c31b6477290a714d356e822',
  'ratchet/rfc6455' => '0.2.4@1612f528c3496ad06e910d0f8b6f16ab97696706',
  'react/cache' => 'v0.5.0@7d7da7fb7574d471904ba357b39bbf110ccdbf66',
  'react/dns' => 'v0.4.16@0a0bedfec72b38406413c6ea01e1c015bd0bf72b',
  'react/event-loop' => 'v1.0.0@0266aff7aa7b0613b1f38a723e14a0ebc55cfca3',
  'react/promise' => 'v2.7.1@31ffa96f8d2ed0341a57848cbb84d88b89dd664d',
  'react/promise-timer' => 'v1.5.0@a11206938ca2394dc7bb368f5da25cd4533fa603',
  'react/socket' => 'v1.2.0@23b7372bb25cea934f6124f5bdac34e30161959e',
  'react/stream' => 'v1.1.0@50426855f7a77ddf43b9266c22320df5bf6c6ce6',
  'react/zmq' => 'v0.4.0@13dec0bd2397adcc5d6aa54c8d7f0982fba66f39',
  'robthree/twofactorauth' => '1.6.7@3407c33775391fa8c36f7d766f26c5e59a736374',
  'slim/psr7' => '1.2.0@832912cb3c2a807d472ef0ac392552e85703a667',
  'slim/slim' => '4.5.0@5613cbb521081ed676d5d7eb3e44f2b80a818c24',
  'spatie/async' => '0.0.4@8b76df4ab77dcf7680eee4b83353d038e28f92f7',
  'symfony/http-foundation' => 'v4.4.7@62f92509c9abfd1f73e17b8cf1b72c0bdac6611b',
  'symfony/mime' => 'v5.0.1@0e6a4ced216e49d457eddcefb61132173a876d79',
  'symfony/polyfill-iconv' => 'v1.20.0@c536646fdb4f29104dd26effc2fdcb9a5b085024',
  'symfony/polyfill-intl-idn' => 'v1.13.1@6f9c239e61e1b0c9229a28ff89a812dc449c3d46',
  'symfony/polyfill-mbstring' => 'v1.20.0@39d483bdf39be819deabf04ec872eb0b2410b531',
  'symfony/polyfill-php72' => 'v1.13.1@66fea50f6cb37a35eea048d75a7d99a45b586038',
  'symfony/process' => 'v4.1.7@3e83acef94d979b1de946599ef86b3a352abcdc9',
  'symfony/routing' => 'v3.2.14@b382d7c4f443372c118efcd0cd2bf1028434f2f5',
  'symfony/translation' => 'v4.3.6@a3aa590ce944afb3434d7a55f81b00927144d5ec',
  'symfony/translation-contracts' => 'v1.1.7@364518c132c95642e530d9b2d217acbc2ccac3e6',
  'tecnickcom/tcpdf' => '6.3.5@19a535eaa7fb1c1cac499109deeb1a7a201b4549',
  'true/punycode' => 'v2.1.1@a4d0c11a36dd7f4e7cd7096076cab6d3378a071e',
  'yzalis/identicon' => '1.1.0@a99fc2a3d018512f7914bc6f972952536c0f309b',
  'zbateson/mail-mime-parser' => '1.3.1@706964d904798b8c22d63f62f0ec5f5bc84e30d9',
  'zbateson/mb-wrapper' => '1.0.1@721b3dfbf7ab75fee5ac60a542d7923ffe59ef6d',
  'zbateson/stream-decorators' => '1.0.4@6f54738dfecc65e1d5bfb855035836748083a6dd',
  'zordius/lightncandy' => 'dev-espo@207d424c4ced34644663fdc0758c19d5b6974adc',
  'espocrm/espocrm' => 'dev-hotfix/6.1.6@6e9f368a0a01b69b28c6d7cb3cdfd94f31d349c2',
);

    private function __construct()
    {
    }

    /**
     * @psalm-pure
     *
     * @psalm-suppress ImpureMethodCall we know that {@see InstalledVersions} interaction does not
     *                                  cause any side effects here.
     */
    public static function rootPackageName() : string
    {
        if (!class_exists(InstalledVersions::class, false) || !InstalledVersions::getRawData()) {
            return self::ROOT_PACKAGE_NAME;
        }

        return InstalledVersions::getRootPackage()['name'];
    }

    /**
     * @throws OutOfBoundsException If a version cannot be located.
     *
     * @psalm-param key-of<self::VERSIONS> $packageName
     * @psalm-pure
     *
     * @psalm-suppress ImpureMethodCall we know that {@see InstalledVersions} interaction does not
     *                                  cause any side effects here.
     */
    public static function getVersion(string $packageName): string
    {
        if (class_exists(InstalledVersions::class, false) && InstalledVersions::getRawData()) {
            return InstalledVersions::getPrettyVersion($packageName)
                . '@' . InstalledVersions::getReference($packageName);
        }

        if (isset(self::VERSIONS[$packageName])) {
            return self::VERSIONS[$packageName];
        }

        throw new OutOfBoundsException(
            'Required package "' . $packageName . '" is not installed: check your ./vendor/composer/installed.json and/or ./composer.lock files'
        );
    }
}
